import json
import random

def load_data(filename):
    with open(filename, 'r') as file:
        data = json.load(file)
    messages = [entry['message'] for entry in data if entry['message']]
    return messages

def build_markov_chain(messages):
    markov_chain = {}
    for message in messages:
        words = message.split()
        for i in range(len(words) - 1):
            word = words[i]
            next_word = words[i + 1]
            if word not in markov_chain:
                markov_chain[word] = []
            markov_chain[word].append(next_word)
    return markov_chain

def generate_response(markov_chain, prompt, length=10):
    word = prompt if prompt in markov_chain else random.choice(list(markov_chain.keys()))
    message = [word]
    for _ in range(length - 1):
        word = random.choice(markov_chain.get(word, [random.choice(list(markov_chain.keys()))]))
        message.append(word)
    return ' '.join(message)

def main():
    messages = load_data('data.json')
    markov_chain = build_markov_chain(messages)
    
    print("Enter a word to start a conversation (type 'exit' to quit):")
    while True:
        prompt = input("You: ")
        if prompt.lower() == 'exit':
            break
        response = generate_response(markov_chain, prompt)
        print("AI:", response)

if __name__ == "__main__":
    main()
